import { RangeCalendarHeading_default } from "../RangeCalendar/RangeCalendarHeading.js";
import { createBlock, createTextVNode, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, toDisplayString, unref, withCtx } from "vue";

//#region src/DateRangePicker/DateRangePickerHeading.vue?vue&type=script&setup=true&lang.ts
var DateRangePickerHeading_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "DateRangePickerHeading",
	props: {
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false
		}
	},
	setup(__props) {
		const props = __props;
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(RangeCalendarHeading_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(({ headingValue }) => [renderSlot(_ctx.$slots, "default", { headingValue }, () => [createTextVNode(toDisplayString(headingValue), 1)])]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/DateRangePicker/DateRangePickerHeading.vue
var DateRangePickerHeading_default = DateRangePickerHeading_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { DateRangePickerHeading_default };
//# sourceMappingURL=DateRangePickerHeading.js.map