import { CalendarHeading_default } from "../Calendar/CalendarHeading.js";
import { createBlock, createTextVNode, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, toDisplayString, unref, withCtx } from "vue";

//#region src/DatePicker/DatePickerHeading.vue?vue&type=script&setup=true&lang.ts
var DatePickerHeading_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "DatePickerHeading",
	props: {
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false
		}
	},
	setup(__props) {
		const props = __props;
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(CalendarHeading_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(({ headingValue }) => [renderSlot(_ctx.$slots, "default", { headingValue }, () => [createTextVNode(toDisplayString(headingValue), 1)])]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/DatePicker/DatePickerHeading.vue
var DatePickerHeading_default = DatePickerHeading_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { DatePickerHeading_default };
//# sourceMappingURL=DatePickerHeading.js.map