import { useForwardExpose } from "../shared/useForwardExpose.js";
import { DialogDescription_default } from "../Dialog/DialogDescription.js";
import { createBlock, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, unref, withCtx } from "vue";

//#region src/AlertDialog/AlertDialogDescription.vue?vue&type=script&setup=true&lang.ts
var AlertDialogDescription_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "AlertDialogDescription",
	props: {
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false,
			default: "p"
		}
	},
	setup(__props) {
		const props = __props;
		useForwardExpose();
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(DialogDescription_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/AlertDialog/AlertDialogDescription.vue
var AlertDialogDescription_default = AlertDialogDescription_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { AlertDialogDescription_default };
//# sourceMappingURL=AlertDialogDescription.js.map