import { _ as _sfc_main$1 } from './index-fMaJOBB-.mjs';
import { n as navigateTo } from './server.mjs';
import { defineComponent, mergeProps, unref, withCtx, createVNode, createTextVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { Calendar, ArrowRight } from 'lucide-vue-next';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Button = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full bg-gradient-cta min-h-[400px] text-white text-center flex flex-col justify-center items-center gap-4 px-4" }, _attrs))}><div class="container text-white text-center flex flex-col justify-center items-center gap-4 max-w-2xl"><h1 class="text-2xl md:text-3xl font-bold" data-aos="fade-up"> Ready to Transform Your Business? </h1><p class="text-lg md:text-xl" data-aos="fade-up"> Schedule a free consultation with our experts and discover how we can help your business thrive in the digital age. </p><br>`);
      _push(ssrRenderComponent(_component_Button, {
        size: "lg",
        onClick: ($event) => ("navigateTo" in _ctx ? _ctx.navigateTo : unref(navigateTo))("/booking"),
        variant: "secondary",
        class: "text-primary",
        "data-aos": "fade-up"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(Calendar), null, null, _parent2, _scopeId));
            _push2(` Book Your Free Consultation `);
            _push2(ssrRenderComponent(unref(ArrowRight), null, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(Calendar)),
              createTextVNode(" Book Your Free Consultation "),
              createVNode(unref(ArrowRight))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/home/cta/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_6 = Object.assign(_sfc_main, { __name: "HomeCta" });
const services = [
  {
    id: "1",
    name: "IT Consultation",
    summary: "Empower your business with expert IT consultation services. We assess your current systems, identify opportunities, and design strategies that align technology with your business goals.",
    features: [
      "Strategic IT planning and advisory",
      "Technology infrastructure assessment",
      "Digital transformation roadmap",
      "Cloud and cybersecurity guidance",
      "Operational cost and efficiency optimization"
    ],
    image: "/images/services/it-consultant.jpg",
    wikiLink: "https://en.wikipedia.org/wiki/Information_technology_consulting"
  },
  {
    id: "2",
    name: "Web Application Development",
    summary: "We design and build robust, scalable, and secure web applications tailored to your business. From concept to deployment, our solutions enhance user experience and drive growth.",
    features: [
      "Custom web solutions tailored to business needs",
      "Responsive and user-friendly UI/UX design",
      "API integration and system connectivity",
      "Maintenance and performance optimization",
      "Secure, scalable architecture with modern frameworks"
    ],
    image: "/images/services/web-development.webp",
    wikiLink: "https://en.wikipedia.org/wiki/Web_application"
  },
  {
    id: "3",
    name: "Network Installation",
    summary: "Ensure seamless connectivity across your organization with professional network installation services. We design and deploy secure, high-performance networks for efficient communication.",
    features: [
      "LAN/WAN design and implementation",
      "Router, switch, and firewall configuration",
      "Wireless and wired network setup",
      "Network monitoring and troubleshooting",
      "Secure VPN and remote access solutions"
    ],
    image: "/images/services/networking.jpg",
    wikiLink: "https://en.wikipedia.org/wiki/Computer_network"
  },
  {
    id: "4",
    name: "Process Automation & Improvement",
    summary: "Automate and optimize your workflows to save time, reduce errors, and boost productivity. We design intelligent automation solutions that streamline repetitive tasks and improve business efficiency.",
    features: [
      "Business process analysis and mapping",
      "Workflow automation using modern tools",
      "Integration of existing systems and APIs",
      "Performance monitoring and reporting",
      "Continuous improvement and optimization"
    ],
    image: "/images/services/automation.webp",
    wikiLink: "https://en.wikipedia.org/wiki/Business_process_automation"
  }
];
const mockGetServices = () => {
  return { items: services };
};

export { __nuxt_component_6 as _, mockGetServices as m };
//# sourceMappingURL=services.mock-DiYsCEB1.mjs.map
