import { _ as __nuxt_component_0 } from './hero-section-BfzZdP6x.mjs';
import { defineComponent, withCtx, unref, createTextVNode, toDisplayString, createVNode, createBlock, openBlock, Fragment, renderList, mergeProps, renderSlot, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderSlot, ssrRenderClass } from 'vue/server-renderer';
import { useForwardPropsEmits, AccordionRoot, useForwardProps, AccordionItem, AccordionHeader, AccordionTrigger, AccordionContent } from 'reka-ui';
import { reactiveOmit } from '@vueuse/core';
import { c as cn } from './utils-H80jjgLf.mjs';
import { Check, ArrowRight, ChevronDown } from 'lucide-vue-next';
import { _ as __nuxt_component_0$1 } from './nuxt-link-BN00xLu-.mjs';
import { m as mockGetServices, _ as __nuxt_component_6 } from './services.mock-DiYsCEB1.mjs';
import { b as bg } from './consultationimg-B5to9-I5.mjs';
import { u as useAppTitle } from './useAppTitle-VPO2yLCv.mjs';
import 'clsx';
import 'tailwind-merge';
import '../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '@iconify/utils';
import 'consola';
import 'ipx';
import './server.mjs';
import 'vue-router';
import './index-fMaJOBB-.mjs';
import 'class-variance-authority';
import './composables-CQCb53iB.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';

const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "Accordion",
  __ssrInlineRender: true,
  props: {
    collapsible: { type: Boolean },
    disabled: { type: Boolean },
    dir: {},
    orientation: {},
    unmountOnHide: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    type: {},
    modelValue: {},
    defaultValue: {}
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props, emits);
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(AccordionRoot), mergeProps({ "data-slot": "accordion" }, unref(forwarded), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ui/accordion/Accordion.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "AccordionContent",
  __ssrInlineRender: true,
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    class: {}
  },
  setup(__props) {
    const props = __props;
    const delegatedProps = reactiveOmit(props, "class");
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(AccordionContent), mergeProps({ "data-slot": "accordion-content" }, unref(delegatedProps), { class: "data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down overflow-hidden text-sm" }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="${ssrRenderClass(unref(cn)("pt-0 pb-4", props.class))}"${_scopeId}>`);
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: unref(cn)("pt-0 pb-4", props.class)
              }, [
                renderSlot(_ctx.$slots, "default")
              ], 2)
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ui/accordion/AccordionContent.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "AccordionItem",
  __ssrInlineRender: true,
  props: {
    disabled: { type: Boolean },
    value: {},
    unmountOnHide: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    class: {}
  },
  setup(__props) {
    const props = __props;
    const delegatedProps = reactiveOmit(props, "class");
    const forwardedProps = useForwardProps(delegatedProps);
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(AccordionItem), mergeProps({ "data-slot": "accordion-item" }, unref(forwardedProps), {
        class: unref(cn)("border-b last:border-b-0", props.class)
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ui/accordion/AccordionItem.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "AccordionTrigger",
  __ssrInlineRender: true,
  props: {
    asChild: { type: Boolean },
    as: {},
    class: {}
  },
  setup(__props) {
    const props = __props;
    const delegatedProps = reactiveOmit(props, "class");
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(AccordionHeader), mergeProps({ class: "flex" }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(AccordionTrigger), mergeProps({ "data-slot": "accordion-trigger" }, unref(delegatedProps), {
              class: unref(cn)(
                "focus-visible:border-ring focus-visible:ring-ring/50 flex flex-1 items-start justify-between gap-4 rounded-md py-4 text-left text-sm font-medium transition-all outline-none hover:underline focus-visible:ring-[3px] disabled:pointer-events-none disabled:opacity-50 [&[data-state=open]>svg]:rotate-180 data-[state=open]:bg-primary data-[state=open]:text-white",
                props.class
              )
            }), {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push3, _parent3, _scopeId2);
                  ssrRenderSlot(_ctx.$slots, "icon", {}, () => {
                    _push3(ssrRenderComponent(unref(ChevronDown), { class: "text-muted-foreground pointer-events-none size-4 shrink-0 translate-y-0.5 transition-transform duration-200" }, null, _parent3, _scopeId2));
                  }, _push3, _parent3, _scopeId2);
                } else {
                  return [
                    renderSlot(_ctx.$slots, "default"),
                    renderSlot(_ctx.$slots, "icon", {}, () => [
                      createVNode(unref(ChevronDown), { class: "text-muted-foreground pointer-events-none size-4 shrink-0 translate-y-0.5 transition-transform duration-200" })
                    ])
                  ];
                }
              }),
              _: 3
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(AccordionTrigger), mergeProps({ "data-slot": "accordion-trigger" }, unref(delegatedProps), {
                class: unref(cn)(
                  "focus-visible:border-ring focus-visible:ring-ring/50 flex flex-1 items-start justify-between gap-4 rounded-md py-4 text-left text-sm font-medium transition-all outline-none hover:underline focus-visible:ring-[3px] disabled:pointer-events-none disabled:opacity-50 [&[data-state=open]>svg]:rotate-180 data-[state=open]:bg-primary data-[state=open]:text-white",
                  props.class
                )
              }), {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "default"),
                  renderSlot(_ctx.$slots, "icon", {}, () => [
                    createVNode(unref(ChevronDown), { class: "text-muted-foreground pointer-events-none size-4 shrink-0 translate-y-0.5 transition-transform duration-200" })
                  ])
                ]),
                _: 3
              }, 16, ["class"])
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ui/accordion/AccordionTrigger.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "services",
  __ssrInlineRender: true,
  setup(__props) {
    useAppTitle("Services");
    const hero = {
      title: "Our Services",
      description: "Discover the range of services we offer to help you achieve your goals",
      bg
    };
    const services = mockGetServices();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_HeroSection = __nuxt_component_0;
      const _component_Accordion = _sfc_main$4;
      const _component_AccordionItem = _sfc_main$2;
      const _component_AccordionTrigger = _sfc_main$1;
      const _component_AccordionContent = _sfc_main$3;
      const _component_NuxtLink = __nuxt_component_0$1;
      const _component_HomeCta = __nuxt_component_6;
      _push(`<main${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_HeroSection, hero, null, _parent));
      _push(`<section class="py-10"><div class="container mx-auto px-4">`);
      _push(ssrRenderComponent(_component_Accordion, {
        type: "single",
        collapsible: ""
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(unref(services)?.items, (service) => {
              _push2(ssrRenderComponent(_component_AccordionItem, {
                key: service.id,
                value: service.id
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_AccordionTrigger, { class: "px-3 md:text-lg lg:text-xl font-bold" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(service.name)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(service.name), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_AccordionContent, { class: "px-3 py-2 md:text-lg" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<p class="text-muted-foreground mb-6"${_scopeId3}>${ssrInterpolate(service.summary)}</p><ul class="space-y-3 mb-6"${_scopeId3}><!--[-->`);
                          ssrRenderList(service.features, (feature) => {
                            _push4(`<li class="flex items-start"${_scopeId3}>`);
                            _push4(ssrRenderComponent(unref(Check), { class: "w-5 h-5 text-primary mr-2 mt-0.5 shrink-0" }, null, _parent4, _scopeId3));
                            _push4(`<span${_scopeId3}>${ssrInterpolate(feature)}</span></li>`);
                          });
                          _push4(`<!--]--></ul>`);
                          _push4(ssrRenderComponent(_component_NuxtLink, {
                            href: service.wikiLink,
                            rel: "noreferrer",
                            target: "_blank",
                            class: "w-full bg-gradient-cta bg-clip-text font-bold group flex items-center"
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(` Learn More `);
                                _push5(ssrRenderComponent(unref(ArrowRight), { class: "w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" }, null, _parent5, _scopeId4));
                              } else {
                                return [
                                  createTextVNode(" Learn More "),
                                  createVNode(unref(ArrowRight), { class: "w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" })
                                ];
                              }
                            }),
                            _: 2
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode("p", { class: "text-muted-foreground mb-6" }, toDisplayString(service.summary), 1),
                            createVNode("ul", { class: "space-y-3 mb-6" }, [
                              (openBlock(true), createBlock(Fragment, null, renderList(service.features, (feature) => {
                                return openBlock(), createBlock("li", {
                                  key: feature,
                                  class: "flex items-start"
                                }, [
                                  createVNode(unref(Check), { class: "w-5 h-5 text-primary mr-2 mt-0.5 shrink-0" }),
                                  createVNode("span", null, toDisplayString(feature), 1)
                                ]);
                              }), 128))
                            ]),
                            createVNode(_component_NuxtLink, {
                              href: service.wikiLink,
                              rel: "noreferrer",
                              target: "_blank",
                              class: "w-full bg-gradient-cta bg-clip-text font-bold group flex items-center"
                            }, {
                              default: withCtx(() => [
                                createTextVNode(" Learn More "),
                                createVNode(unref(ArrowRight), { class: "w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" })
                              ]),
                              _: 1
                            }, 8, ["href"])
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_AccordionTrigger, { class: "px-3 md:text-lg lg:text-xl font-bold" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(service.name), 1)
                        ]),
                        _: 2
                      }, 1024),
                      createVNode(_component_AccordionContent, { class: "px-3 py-2 md:text-lg" }, {
                        default: withCtx(() => [
                          createVNode("p", { class: "text-muted-foreground mb-6" }, toDisplayString(service.summary), 1),
                          createVNode("ul", { class: "space-y-3 mb-6" }, [
                            (openBlock(true), createBlock(Fragment, null, renderList(service.features, (feature) => {
                              return openBlock(), createBlock("li", {
                                key: feature,
                                class: "flex items-start"
                              }, [
                                createVNode(unref(Check), { class: "w-5 h-5 text-primary mr-2 mt-0.5 shrink-0" }),
                                createVNode("span", null, toDisplayString(feature), 1)
                              ]);
                            }), 128))
                          ]),
                          createVNode(_component_NuxtLink, {
                            href: service.wikiLink,
                            rel: "noreferrer",
                            target: "_blank",
                            class: "w-full bg-gradient-cta bg-clip-text font-bold group flex items-center"
                          }, {
                            default: withCtx(() => [
                              createTextVNode(" Learn More "),
                              createVNode(unref(ArrowRight), { class: "w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" })
                            ]),
                            _: 1
                          }, 8, ["href"])
                        ]),
                        _: 2
                      }, 1024)
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(unref(services)?.items, (service) => {
                return openBlock(), createBlock(_component_AccordionItem, {
                  key: service.id,
                  value: service.id
                }, {
                  default: withCtx(() => [
                    createVNode(_component_AccordionTrigger, { class: "px-3 md:text-lg lg:text-xl font-bold" }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(service.name), 1)
                      ]),
                      _: 2
                    }, 1024),
                    createVNode(_component_AccordionContent, { class: "px-3 py-2 md:text-lg" }, {
                      default: withCtx(() => [
                        createVNode("p", { class: "text-muted-foreground mb-6" }, toDisplayString(service.summary), 1),
                        createVNode("ul", { class: "space-y-3 mb-6" }, [
                          (openBlock(true), createBlock(Fragment, null, renderList(service.features, (feature) => {
                            return openBlock(), createBlock("li", {
                              key: feature,
                              class: "flex items-start"
                            }, [
                              createVNode(unref(Check), { class: "w-5 h-5 text-primary mr-2 mt-0.5 shrink-0" }),
                              createVNode("span", null, toDisplayString(feature), 1)
                            ]);
                          }), 128))
                        ]),
                        createVNode(_component_NuxtLink, {
                          href: service.wikiLink,
                          rel: "noreferrer",
                          target: "_blank",
                          class: "w-full bg-gradient-cta bg-clip-text font-bold group flex items-center"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" Learn More "),
                            createVNode(unref(ArrowRight), { class: "w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" })
                          ]),
                          _: 1
                        }, 8, ["href"])
                      ]),
                      _: 2
                    }, 1024)
                  ]),
                  _: 2
                }, 1032, ["value"]);
              }), 128))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></section>`);
      _push(ssrRenderComponent(_component_HomeCta, null, null, _parent));
      _push(`</main>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/services.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=services-7G9Sxi3m.mjs.map
