import { _ as __nuxt_component_0 } from './hero-section-BfzZdP6x.mjs';
import { _ as _sfc_main$6 } from './CardTitle-BpogD0MX.mjs';
import __nuxt_component_2 from './index-s4nps6DV.mjs';
import { defineComponent, withCtx, createVNode, toDisplayString, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderAttr } from 'vue/server-renderer';
import { i as image } from './homehero-XVg98Oq1.mjs';
import './utils-H80jjgLf.mjs';
import 'clsx';
import 'tailwind-merge';
import './server.mjs';
import '../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '@iconify/utils';
import 'consola';
import 'ipx';
import 'vue-router';
import '@vueuse/core';
import './composables-CQCb53iB.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import './asyncData-Dhy4eyVS.mjs';
import 'perfect-debounce';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "about",
  __ssrInlineRender: true,
  setup(__props) {
    const hero = {
      title: "About us",
      description: "Learn more about our mission, vision, and values",
      bg: image
    };
    const stats = [
      { label: "Clients Served", value: "500+", icon: "lucide:users" },
      { label: "Years Experience", value: "10+", icon: "lucide:award" },
      { label: "Projects Completed", value: "1000+", icon: "lucide:trending-up" },
      { label: "Customer Satisfaction", value: "98%", icon: "lucide:heart" }
    ];
    const team = [
      {
        name: "Alex Morgan",
        role: "CEO & Founder",
        image: "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400"
      },
      {
        name: "Sarah Chen",
        role: "CTO",
        image: "https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=400"
      },
      {
        name: "Michael Rodriguez",
        role: "Head of Consulting",
        image: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400"
      },
      {
        name: "Emily Taylor",
        role: "Lead Security Engineer",
        image: "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=400"
      }
    ];
    const values = [
      { name: "Excellence" },
      { name: "Innovation" },
      { name: "Integrity" }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_HeroSection = __nuxt_component_0;
      const _component_Card = _sfc_main$6;
      const _component_Icon = __nuxt_component_2;
      _push(`<main${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_HeroSection, hero, null, _parent));
      _push(`<section class="py-20 bg-muted"><div class="container mx-auto px-4"><div class="grid md:grid-cols-2 gap-12 max-w-5xl mx-auto">`);
      _push(ssrRenderComponent(_component_Card, { class: "p-8 animate-fade-in" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<h2 class="text-3xl font-bold mb-4"${_scopeId}>Our Mission</h2><p class="text-muted-foreground leading-relaxed"${_scopeId}> To empower businesses of all sizes with cutting-edge technology solutions and expert guidance, enabling them to thrive in the digital age. We believe in building long-term partnerships based on trust, innovation, and measurable results. </p>`);
          } else {
            return [
              createVNode("h2", { class: "text-3xl font-bold mb-4" }, "Our Mission"),
              createVNode("p", { class: "text-muted-foreground leading-relaxed" }, " To empower businesses of all sizes with cutting-edge technology solutions and expert guidance, enabling them to thrive in the digital age. We believe in building long-term partnerships based on trust, innovation, and measurable results. ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Card, {
        class: "p-8 animate-fade-in",
        style: { animationDelay: "100ms" }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<h2 class="text-3xl font-bold mb-4"${_scopeId}>Our Vision</h2><p class="text-muted-foreground leading-relaxed"${_scopeId}> To be the leading IT consulting and technology provider, recognized for our commitment to excellence, innovation, and customer success. We envision a future where every business has access to world-class IT solutions that drive growth and transformation. </p>`);
          } else {
            return [
              createVNode("h2", { class: "text-3xl font-bold mb-4" }, "Our Vision"),
              createVNode("p", { class: "text-muted-foreground leading-relaxed" }, " To be the leading IT consulting and technology provider, recognized for our commitment to excellence, innovation, and customer success. We envision a future where every business has access to world-class IT solutions that drive growth and transformation. ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></section><section class="py-20"><div class="container mx-auto px-4"><div class="grid grid-cols-2 lg:grid-cols-4 gap-6"><!--[-->`);
      ssrRenderList(stats, (stat, index) => {
        _push(ssrRenderComponent(_component_Card, {
          key: index,
          class: "p-6 text-center hover:shadow-strong transition-all duration-300 hover:-translate-y-2 animate-fade-in",
          style: { animationDelay: `${index * 100}ms` }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="w-14 h-14 rounded-full bg-gradient-cta flex items-center justify-center mx-auto mb-4"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Icon, {
                name: stat.icon,
                mode: "svg",
                class: "w-7 h-7 text-white"
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="text-3xl font-bold text-primary mb-2"${_scopeId}>${ssrInterpolate(stat.value)}</div><div class="text-muted-foreground"${_scopeId}>${ssrInterpolate(stat.label)}</div>`);
            } else {
              return [
                createVNode("div", { class: "w-14 h-14 rounded-full bg-gradient-cta flex items-center justify-center mx-auto mb-4" }, [
                  createVNode(_component_Icon, {
                    name: stat.icon,
                    mode: "svg",
                    class: "w-7 h-7 text-white"
                  }, null, 8, ["name"])
                ]),
                createVNode("div", { class: "text-3xl font-bold text-primary mb-2" }, toDisplayString(stat.value), 1),
                createVNode("div", { class: "text-muted-foreground" }, toDisplayString(stat.label), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div></section><section class="py-20"><div class="container mx-auto px-4"><div class="text-center mb-12 animate-fade-in"><h2 class="text-3xl md:text-4xl font-bold mb-4">Meet Our Team</h2><p class="text-muted-foreground text-lg max-w-2xl mx-auto"> Experienced professionals dedicated to your success </p></div><div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8"><!--[-->`);
      ssrRenderList(team, (member, index) => {
        _push(ssrRenderComponent(_component_Card, {
          key: member.name,
          class: "overflow-hidden hover:shadow-strong transition-all duration-300 hover:-translate-y-2 animate-fade-in py-0",
          style: { animationDelay: `${index * 100}ms` }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="aspect-square overflow-hidden"${_scopeId}><img${ssrRenderAttr("src", member.image)}${ssrRenderAttr("alt", member.name)} class="w-full h-full object-cover hover:scale-110 transition-transform duration-500"${_scopeId}></div><div class="p-6 text-center"${_scopeId}><h3 class="text-xl font-semibold mb-1"${_scopeId}>${ssrInterpolate(member.name)}</h3><p class="text-muted-foreground"${_scopeId}>${ssrInterpolate(member.role)}</p></div>`);
            } else {
              return [
                createVNode("div", { class: "aspect-square overflow-hidden" }, [
                  createVNode("img", {
                    src: member.image,
                    alt: member.name,
                    class: "w-full h-full object-cover hover:scale-110 transition-transform duration-500"
                  }, null, 8, ["src", "alt"])
                ]),
                createVNode("div", { class: "p-6 text-center" }, [
                  createVNode("h3", { class: "text-xl font-semibold mb-1" }, toDisplayString(member.name), 1),
                  createVNode("p", { class: "text-muted-foreground" }, toDisplayString(member.role), 1)
                ])
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div></section><section class="py-20 bg-gradient-cta text-white"><div class="container mx-auto px-4"><div class="text-center mb-12 animate-fade-in"><h2 class="text-3xl md:text-4xl font-bold mb-4">Our Values</h2><p class="text-white/90 text-lg max-w-2xl mx-auto"> The principles that guide everything we do </p></div><div class="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto"><!--[-->`);
      ssrRenderList(values, (value, index) => {
        _push(ssrRenderComponent(_component_Card, {
          key: index,
          class: "p-8 bg-white/10 backdrop-blur-sm border-white/20 text-white hover:bg-white/20 transition-all duration-300 animate-fade-in",
          style: { animationDelay: `${index * 100}ms` }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<h3 class="text-2xl font-bold mb-3"${_scopeId}>${ssrInterpolate(value.name)}</h3><p class="text-white/90"${_scopeId}> We are committed to delivering the highest quality solutions and exceeding our clients&#39; expectations in every interaction. </p>`);
            } else {
              return [
                createVNode("h3", { class: "text-2xl font-bold mb-3" }, toDisplayString(value.name), 1),
                createVNode("p", { class: "text-white/90" }, " We are committed to delivering the highest quality solutions and exceeding our clients' expectations in every interaction. ")
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div></section></main>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/about.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=about-pQrz49Qe.mjs.map
