import { _ as __nuxt_component_0 } from './hero-section-BfzZdP6x.mjs';
import { defineComponent, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { m as mockGetBlog } from './blog.mock-DneuJwpc.mjs';
import { a as useRoute, c as createError } from './server.mjs';
import '../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '@iconify/utils';
import 'consola';
import 'ipx';
import 'vue-router';
import '@vueuse/core';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "[slug]",
  __ssrInlineRender: true,
  setup(__props) {
    const { params } = useRoute();
    const post = mockGetBlog().items.find((item) => item.slug === params.slug);
    if (!post) {
      throw createError({ statusCode: 404, statusMessage: "Post not found" });
    }
    const heroData = {
      title: post.title ?? "",
      description: post.excerpt ?? "",
      bg: post.image ?? ""
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_HeroSection = __nuxt_component_0;
      _push(`<main${ssrRenderAttrs(_attrs)}>`);
      if (unref(post)) {
        _push(ssrRenderComponent(_component_HeroSection, heroData, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<section class="container mx-auto"><article class="prose min-w-full lg:prose-lg xl:prose-xl mx-auto my-10">${unref(post)?.content ?? ""}</article></section></main>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/blog/[slug].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=_slug_-CB2uKoTN.mjs.map
